/*
 * ATTINY_ATX_SMPS.c
 *
 * Created: 22.11.2015 19:10:11
 *  Author: Gabriel
 */ 


#include <avr/io.h>
#include <util/delay.h>
#include <stdbool.h>
#define F_CPU 8000000					// Define CPU Speed (Internal Oscillator has 8MHz)
#define BUTTONBIT PINB1				// Set here the Input pin of the Button



int main(void)
{
	DDRB = 0b0000001;					//define Inputs & Outputs: 0 = Input, 1 = Output 
	PORTB = 0b0000000;					//turn Output OFF
	bool LASTSTATE = false;				//create a bool variable for Last Status of the Input
	_delay_ms (3000);					//Delay to give the Voltmeter time to Boot, before output can be turned on.
	
    while(1)							
    {
		{
			
			if (PINB & (1<<BUTTONBIT)) // if the button is pressed
			{
				
				if (PORTB == 0b0000000 && LASTSTATE == false) // If Output is OFF and the button was not pressed turn the output ON and mark button as pressed
				{
					PORTB = (1<<PB0);
					LASTSTATE = true;
				}
				
				else if (PORTB == 0b0000001 && LASTSTATE == false) // If Output is ON and the button was not pressed turn the output OFF and mark button as pressed
				{
					PORTB = (0<<PB0);
					LASTSTATE = true;
				}
				else{}										// do nothing
					
				_delay_ms(100);								// Short delay to eliminate the bouncing of the button
				
			}
			else {LASTSTATE = false;}							// mark button as not pressed.
		}
    }
}


